<?php
/**
 * Dashboard View - Flowb0t DCI v2.0 Professional
 * Variables available: $data, $logs, $processId, $currentPage
 * All text in ENGLISH
 */

$baseUrl = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\');

// Calculate percentages
$total = max($data['total_links'], 1);
$processedPercent = round(($data['processed_links'] / $total) * 100, 1);
$importedPercent = round(($data['imported_links'] / $total) * 100, 1);
$ignoredPercent = round(($data['ignored_links'] / $total) * 100, 1);
$errorPercent = round(($data['error_links'] / $total) * 100, 1);
$totalProcessedPercent = round((($data['processed_links'] + $data['ignored_links'] + $data['error_links']) / $total) * 100, 1);

// Format times
$elapsedTime = gmdate('H:i:s', (int)($data['elapsed_time'] ?? 0));
$remainingTime = gmdate('H:i:s', (int)($data['remaining_time'] ?? 0));
$totalTime = gmdate('H:i:s', (int)(($data['elapsed_time'] ?? 0) + ($data['remaining_time'] ?? 0)));
$lastBatchTime = number_format($data['last_batch_time'] ?? 0, 2) . 's';
$maxBatchTime = number_format($data['max_batch_time'] ?? 0, 2) . 's';
$avgBatchTime = $data['batches_processed'] > 0
    ? number_format($data['elapsed_time'] / $data['batches_processed'], 2) . 's'
    : '0.00s';

// Memory usage
$memoryUsage = round(memory_get_usage(true) / 1024 / 1024, 2);

// Remaining links
$remainingLinks = 0;
foreach ($data['phase_queues'] ?? [] as $queue) {
    $remainingLinks += count($queue);
}
$remainingPercent = round(($remainingLinks / $total) * 100, 1);

// Current phase
$currentPhase = $data['phase_index'] ?? 0;

// Is complete?
$isComplete = ($remainingLinks === 0);

// Status indicator class
$statusClass = $isComplete ? 'complete' : 'processing';
if ($isComplete && $data['error_links'] > 0) {
    $statusClass = 'has-errors';
}

// Domain stats summary
$domainStats = $data['domain_stats'] ?? [];
$totalDomains = count($domainStats);

// v2.1: Request stats and HTTP codes
$requestStats = $data['request_stats'] ?? [];
$totalRequests = $requestStats['total_requests'] ?? 0;
$avgResponseTime = $totalRequests > 0
    ? round(($requestStats['total_response_time'] ?? 0) / $totalRequests, 2)
    : 0;
$minResponseTime = ($requestStats['min_response_time'] ?? PHP_FLOAT_MAX) < PHP_FLOAT_MAX
    ? round($requestStats['min_response_time'], 2)
    : 0;
$maxResponseTime = round($requestStats['max_response_time'] ?? 0, 2);

// Calculate percentiles from response_times array
$responseTimes = $requestStats['response_times'] ?? [];
$p50 = $p90 = $p99 = 0;
if (!empty($responseTimes)) {
    sort($responseTimes);
    $count = count($responseTimes);
    $p50 = round($responseTimes[(int)floor($count * 0.50)] ?? 0, 2);
    $p90 = round($responseTimes[(int)floor($count * 0.90)] ?? 0, 2);
    $p99 = round($responseTimes[(int)floor($count * 0.99)] ?? 0, 2);
}

// HTTP codes
$httpCodes = $data['http_codes'] ?? [];
arsort($httpCodes);
$totalCodes = array_sum($httpCodes) ?: 1;

// Retry stats
$retryStats = $data['retry_stats'] ?? [];
$totalRetries = $retryStats['total_retries'] ?? 0;

// Success rate
$successRate = $total > 0 ? round(($data['imported_links'] / $total) * 100, 1) : 0;

// Helper: HTTP code name
$getCodeName = function($code) {
    return match((int)$code) {
        200 => 'OK', 201 => 'Created', 204 => 'No Content',
        301 => 'Moved', 302 => 'Redirect', 304 => 'Not Modified',
        400 => 'Bad Request', 401 => 'Unauthorized', 403 => 'Forbidden',
        404 => 'Not Found', 405 => 'Method Not Allowed', 408 => 'Timeout',
        429 => 'Rate Limit', 451 => 'Unavailable',
        500 => 'Server Error', 502 => 'Bad Gateway',
        503 => 'Unavailable', 504 => 'Gateway Timeout',
        default => '',
    };
};
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - <?= htmlspecialchars($processId) ?></title>
    <link rel="stylesheet" href="<?= $baseUrl ?>/assets/css/style.css">
    <style>
        body {
            background: linear-gradient(135deg, #0F172A 0%, #1E293B 50%, #0F172A 100%);
            min-height: 100vh;
        }
    </style>
</head>
<body>
    <?php $currentPage = 'dashboard'; include __DIR__ . '/partials/navigation.php'; ?>

    <div class="dashboard compact">
        <?php if ($isComplete): ?>
        <!-- ============ COMPLETE SUMMARY ============ -->
        <div class="complete-summary glass-card">
            <h2>Processing Complete!</h2>
            <p>All <?= number_format($data['total_links']) ?> URLs processed in <?= $elapsedTime ?></p>
            <div class="summary-stats">
                <div class="summary-stat success">
                    <div class="value"><?= number_format($data['imported_links']) ?></div>
                    <div class="label">Imported</div>
                </div>
                <div class="summary-stat warning">
                    <div class="value"><?= number_format($data['ignored_links']) ?></div>
                    <div class="label">Ignored</div>
                </div>
                <div class="summary-stat error">
                    <div class="value"><?= number_format($data['error_links']) ?></div>
                    <div class="label">Errors</div>
                </div>
                <div class="summary-stat info">
                    <div class="value"><?= $totalDomains ?></div>
                    <div class="label">Domains</div>
                </div>
            </div>
        </div>
        <?php endif; ?>

        <!-- ============ ROW 1: Progress Circle + KPIs ============ -->
        <div class="dashboard-row">
            <!-- Progress Circle -->
            <div class="kpi-card progress-card glass-card">
                <div class="progress-circle" style="--progress: <?= $totalProcessedPercent ?>">
                    <span class="circle-value"><?= $totalProcessedPercent ?>%</span>
                </div>
                <div class="label">Total Progress</div>
            </div>

            <!-- KPIs Grid -->
            <div class="kpi-card glass-card">
                <div class="kpi-grid">
                    <div class="kpi-mini" data-tooltip="Current processing rate">
                        <span class="icon">&#9889;</span>
                        <span class="value"><?= $data['processing_rate'] ?></span>
                        <span class="label">links/s</span>
                    </div>
                    <div class="kpi-mini" data-tooltip="Estimated remaining time">
                        <span class="icon">&#9201;</span>
                        <span class="value"><?= $remainingTime ?></span>
                        <span class="label">remaining</span>
                    </div>
                    <div class="kpi-mini" data-tooltip="Current memory usage">
                        <span class="icon">&#128190;</span>
                        <span class="value"><?= $memoryUsage ?></span>
                        <span class="label">MB</span>
                    </div>
                    <div class="kpi-mini" data-tooltip="Batches processed">
                        <span class="icon">&#128260;</span>
                        <span class="value"><?= $data['batches_processed'] ?></span>
                        <span class="label">batches</span>
                    </div>
                    <div class="kpi-mini" data-tooltip="Total unique domains">
                        <span class="icon">&#127760;</span>
                        <span class="value"><?= $totalDomains ?></span>
                        <span class="label">domains</span>
                    </div>
                    <div class="kpi-mini" data-tooltip="Current phase">
                        <span class="icon">&#128200;</span>
                        <span class="value"><?= $currentPhase ?></span>
                        <span class="label">phase</span>
                    </div>
                </div>
            </div>
        </div>

        <!-- ============ v2.1: RESPONSE TIME & HTTP CODE KPIS ============ -->
        <div class="dashboard-row four-cols">
            <div class="kpi-mini-card glass-card">
                <div class="kpi-icon">&#9201;</div>
                <div class="kpi-content">
                    <span class="kpi-value"><?= $avgResponseTime ?>s</span>
                    <span class="kpi-label">Avg Response</span>
                </div>
            </div>
            <div class="kpi-mini-card glass-card">
                <div class="kpi-icon">&#128200;</div>
                <div class="kpi-content">
                    <span class="kpi-value"><?= $p90 ?>s</span>
                    <span class="kpi-label">P90 Response</span>
                </div>
            </div>
            <div class="kpi-mini-card glass-card">
                <div class="kpi-icon">&#8635;</div>
                <div class="kpi-content">
                    <span class="kpi-value"><?= number_format($totalRetries) ?></span>
                    <span class="kpi-label">Total Retries</span>
                </div>
            </div>
            <div class="kpi-mini-card glass-card <?= $successRate >= 80 ? 'success' : ($successRate >= 50 ? 'warning' : 'error') ?>">
                <div class="kpi-icon">&#10003;</div>
                <div class="kpi-content">
                    <span class="kpi-value"><?= $successRate ?>%</span>
                    <span class="kpi-label">Success Rate</span>
                </div>
            </div>
        </div>

        <!-- ============ v2.1: HTTP CODES & RESPONSE TIMES ROW ============ -->
        <?php if (!empty($httpCodes) || $totalRequests > 0): ?>
        <div class="dashboard-row two-cols">
            <!-- HTTP Response Codes Card -->
            <div class="http-codes-card glass-card">
                <h4>HTTP Response Codes</h4>
                <div class="http-codes-list">
                    <?php foreach (array_slice($httpCodes, 0, 6, true) as $code => $count):
                        $percent = round(($count / $totalCodes) * 100, 1);
                        $codeClass = match(true) {
                            (int)$code >= 200 && (int)$code < 300 => 'success',
                            (int)$code >= 300 && (int)$code < 400 => 'info',
                            (int)$code >= 400 && (int)$code < 500 => 'warning',
                            (int)$code >= 500 => 'error',
                            default => 'info',
                        };
                        $codeName = $getCodeName($code);
                    ?>
                    <div class="http-code-row">
                        <span class="http-code <?= $codeClass ?>"><?= $code ?></span>
                        <span class="http-name"><?= $codeName ?></span>
                        <div class="http-bar">
                            <div class="http-bar-fill <?= $codeClass ?>" style="width: <?= $percent ?>%"></div>
                        </div>
                        <span class="http-count"><?= number_format($count) ?> (<?= $percent ?>%)</span>
                    </div>
                    <?php endforeach; ?>
                    <?php if (empty($httpCodes)): ?>
                    <div class="no-data">No HTTP codes recorded yet</div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Response Time Stats Card -->
            <div class="response-time-card glass-card">
                <h4>Response Time Analysis</h4>
                <div class="response-time-grid">
                    <div class="rt-stat">
                        <span class="rt-label">Average</span>
                        <span class="rt-value"><?= $avgResponseTime ?>s</span>
                    </div>
                    <div class="rt-stat">
                        <span class="rt-label">Min</span>
                        <span class="rt-value success"><?= $minResponseTime ?>s</span>
                    </div>
                    <div class="rt-stat">
                        <span class="rt-label">P50</span>
                        <span class="rt-value"><?= $p50 ?>s</span>
                    </div>
                    <div class="rt-stat">
                        <span class="rt-label">Max</span>
                        <span class="rt-value error"><?= $maxResponseTime ?>s</span>
                    </div>
                    <div class="rt-stat">
                        <span class="rt-label">P90</span>
                        <span class="rt-value warning"><?= $p90 ?>s</span>
                    </div>
                    <div class="rt-stat">
                        <span class="rt-label">P99</span>
                        <span class="rt-value error"><?= $p99 ?>s</span>
                    </div>
                </div>
                <?php if ($totalRetries > 0): ?>
                <div class="retry-breakdown">
                    <h5>Retries by Phase</h5>
                    <div class="retry-phases">
                        <?php for ($i = 0; $i < 4; $i++):
                            $phaseRetries = $retryStats['retries_by_phase'][$i] ?? 0;
                        ?>
                        <div class="retry-phase">
                            <span class="phase-num">P<?= $i ?></span>
                            <span class="phase-retries"><?= $phaseRetries ?></span>
                        </div>
                        <?php endfor; ?>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>

        <!-- ============ SEGMENTED PROGRESS BAR ============ -->
        <div class="segmented-progress glass-card">
            <?php if ($importedPercent > 0): ?>
            <div class="segment imported" style="width: <?= max($importedPercent, 3) ?>%"
                 title="Imported: <?= number_format($data['imported_links']) ?> (<?= $importedPercent ?>%)">
                <span><?= $data['imported_links'] ?></span>
            </div>
            <?php endif; ?>
            <?php if ($ignoredPercent > 0): ?>
            <div class="segment ignored" style="width: <?= max($ignoredPercent, 3) ?>%"
                 title="Ignored: <?= number_format($data['ignored_links']) ?> (<?= $ignoredPercent ?>%)">
                <span><?= $data['ignored_links'] ?></span>
            </div>
            <?php endif; ?>
            <?php if ($errorPercent > 0): ?>
            <div class="segment error" style="width: <?= max($errorPercent, 3) ?>%"
                 title="Errors: <?= number_format($data['error_links']) ?> (<?= $errorPercent ?>%)">
                <span><?= $data['error_links'] ?></span>
            </div>
            <?php endif; ?>
            <?php if ($remainingPercent > 0): ?>
            <div class="segment remaining" style="width: <?= $remainingPercent ?>%"
                 title="Remaining: <?= number_format($remainingLinks) ?> (<?= $remainingPercent ?>%)">
                <span><?= $remainingLinks ?></span>
            </div>
            <?php endif; ?>
        </div>

        <!-- ============ ROW 2: Status Cards ============ -->
        <div class="dashboard-row three-cols">
            <!-- IMPORTED Card -->
            <div class="status-card imported glass-card">
                <div class="card-header">
                    <span class="card-title">Imported</span>
                    <span class="card-icon">&#10004;</span>
                </div>
                <div class="card-value animated-value"><?= number_format($data['imported_links']) ?></div>
                <div class="card-percentage"><?= $importedPercent ?>% of total</div>
                <div class="mini-bar">
                    <div class="fill" style="width: <?= $importedPercent ?>%"></div>
                </div>
            </div>

            <!-- IGNORED Card -->
            <div class="status-card ignored glass-card">
                <div class="card-header">
                    <span class="card-title">Ignored</span>
                    <span class="card-icon">&#9888;</span>
                </div>
                <div class="card-value animated-value"><?= number_format($data['ignored_links']) ?></div>
                <div class="card-percentage"><?= $ignoredPercent ?>% of total</div>
                <div class="mini-bar">
                    <div class="fill" style="width: <?= $ignoredPercent ?>%"></div>
                </div>
                <?php if (!empty($data['ignored_details']) && $data['ignored_links'] > 0): ?>
                <div class="details-dropdown">
                    <div class="detail-row">
                        <span class="label">&#128260; Duplicates</span>
                        <span class="value"><?= number_format($data['ignored_details']['duplicate'] ?? 0) ?></span>
                    </div>
                    <div class="detail-row">
                        <span class="label">&#10060; Invalid URL</span>
                        <span class="value"><?= number_format($data['ignored_details']['invalid_url'] ?? 0) ?></span>
                    </div>
                    <div class="detail-row">
                        <span class="label">&#128683; Blocked Domain</span>
                        <span class="value"><?= number_format($data['ignored_details']['blocked_domain'] ?? 0) ?></span>
                    </div>
                    <div class="detail-row">
                        <span class="label">&#128196; Non-HTML</span>
                        <span class="value"><?= number_format($data['ignored_details']['non_html'] ?? 0) ?></span>
                    </div>
                </div>
                <?php endif; ?>
            </div>

            <!-- ERROR Card -->
            <div class="status-card error glass-card">
                <div class="card-header">
                    <span class="card-title">Errors</span>
                    <span class="card-icon">&#10060;</span>
                </div>
                <div class="card-value animated-value"><?= number_format($data['error_links']) ?></div>
                <div class="card-percentage"><?= $errorPercent ?>% of total</div>
                <div class="mini-bar">
                    <div class="fill" style="width: <?= $errorPercent ?>%"></div>
                </div>
                <?php if (!empty($data['error_details']) && $data['error_links'] > 0): ?>
                <div class="details-dropdown">
                    <div class="detail-row">
                        <span class="label">&#9201; Timeout</span>
                        <span class="value"><?= number_format($data['error_details']['timeout'] ?? 0) ?></span>
                    </div>
                    <div class="detail-row">
                        <span class="label">&#128678; HTTP 429</span>
                        <span class="value"><?= number_format($data['error_details']['http_429'] ?? 0) ?></span>
                    </div>
                    <div class="detail-row">
                        <span class="label">&#128269; HTTP 404</span>
                        <span class="value"><?= number_format($data['error_details']['http_404'] ?? 0) ?></span>
                    </div>
                    <div class="detail-row">
                        <span class="label">&#128274; HTTP 403</span>
                        <span class="value"><?= number_format($data['error_details']['http_403'] ?? 0) ?></span>
                    </div>
                    <div class="detail-row">
                        <span class="label">&#128165; Server 5xx</span>
                        <span class="value"><?= number_format($data['error_details']['http_5xx'] ?? 0) ?></span>
                    </div>
                    <div class="detail-row">
                        <span class="label">&#128268; Connection</span>
                        <span class="value"><?= number_format($data['error_details']['connection'] ?? 0) ?></span>
                    </div>
                    <div class="detail-row">
                        <span class="label">&#128221; Metadata</span>
                        <span class="value"><?= number_format($data['error_details']['metadata'] ?? 0) ?></span>
                    </div>
                    <div class="detail-row">
                        <span class="label">&#10067; Other</span>
                        <span class="value"><?= number_format($data['error_details']['other'] ?? 0) ?></span>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- ============ PHASE PIPELINE ============ -->
        <div class="phase-pipeline glass-card">
            <?php for ($i = 0; $i <= 3; $i++):
                $stats = $data['phase_stats'][$i] ?? ['success' => 0, 'retry' => 0, 'error' => 0];
                $isActive = ($i === $currentPhase);
                $isCompleted = ($i < $currentPhase) || ($isComplete && $i <= $currentPhase);
                $pending = count($data['phase_queues'][$i] ?? []);
            ?>
            <?php if ($i > 0): ?>
            <div class="phase-connector <?= $isCompleted ? 'completed' : '' ?>"></div>
            <?php endif; ?>
            <div class="phase-node <?= $isActive ? 'active' : '' ?> <?= $isCompleted && !$isActive ? 'completed' : '' ?>">
                <div class="phase-title">Phase <?= $i ?></div>
                <div class="phase-stats">
                    <span style="color:#10B981">&#10003;<?= $stats['success'] ?></span>
                    <span style="color:#F59E0B">&#8635;<?= $stats['retry'] ?></span>
                    <span style="color:#EF4444">&#10007;<?= $stats['error'] ?></span>
                </div>
                <?php if ($pending > 0): ?>
                <div class="phase-pending"><?= number_format($pending) ?> pending</div>
                <?php endif; ?>
            </div>
            <?php endfor; ?>
        </div>

        <!-- ============ TERMINAL ============ -->
        <div class="terminal-container glass-card">
            <div class="terminal-header">
                <span class="title">Processing Logs</span>
                <div class="terminal-filters">
                    <span class="terminal-filter active" data-filter="all">All</span>
                    <span class="terminal-filter success" data-filter="success">Success</span>
                    <span class="terminal-filter warning" data-filter="warning">Warning</span>
                    <span class="terminal-filter error" data-filter="error">Error</span>
                </div>
                <a href="?process_id=<?= urlencode($processId) ?>&page=logs" class="view-all-link">View All &#8594;</a>
            </div>
            <div class="terminal-body">
                <?php foreach ($logs as $log): ?>
                <div class="log-line <?= $log['class'] ?? '' ?>" data-type="<?= $log['class'] ?? 'info' ?>">
                    <span class="log-icon">
                        <?php if (($log['class'] ?? '') === 'success'): ?>&#10004;
                        <?php elseif (($log['class'] ?? '') === 'warning'): ?>&#9888;
                        <?php elseif (($log['class'] ?? '') === 'error'): ?>&#10060;
                        <?php else: ?>&#8505;<?php endif; ?>
                    </span>
                    <span class="log-url"><?= htmlspecialchars($log['url'] ?? '') ?></span>
                    <span class="log-message"><?= htmlspecialchars($log['message'] ?? '') ?></span>
                </div>
                <?php endforeach; ?>
            </div>
        </div>

        <!-- ============ ROW 3: Timing & Stats ============ -->
        <div class="dashboard-row">
            <!-- Timing Card -->
            <div class="kpi-card timing-card glass-card">
                <h4>Time</h4>
                <div class="timing-grid">
                    <div>
                        <span class="label">Elapsed</span>
                        <span class="value"><?= $elapsedTime ?></span>
                    </div>
                    <div>
                        <span class="label">Remaining</span>
                        <span class="value"><?= $remainingTime ?></span>
                    </div>
                    <div>
                        <span class="label">Est. Total</span>
                        <span class="value"><?= $totalTime ?></span>
                    </div>
                </div>
            </div>

            <!-- Stats Card -->
            <div class="kpi-card stats-card glass-card">
                <h4>Statistics</h4>
                <div class="stats-grid-inner">
                    <div>
                        <span class="label">Total URLs</span>
                        <span class="value"><?= number_format($data['total_links']) ?></span>
                    </div>
                    <div>
                        <span class="label">Avg Batch</span>
                        <span class="value"><?= $avgBatchTime ?></span>
                    </div>
                    <div>
                        <span class="label">Max Batch</span>
                        <span class="value"><?= $maxBatchTime ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="<?= $baseUrl ?>/assets/js/app.js"></script>
    <script>
        // Pass process ID to JavaScript
        window.processId = '<?= htmlspecialchars($processId) ?>';
        window.isComplete = <?= $isComplete ? 'true' : 'false' ?>;
    </script>
</body>
</html>
